/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.ordana.spelunkery.blocks.GlowstickBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModItems;
import java.util.HashMap;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowstickEntity
extends ImprovedProjectileEntity {
    private static final EntityDataAccessor<Integer> DATA_GLOWSTICK_COLOR;
    public static final HashMap<DyeColor, Block> DYE_COLOR_TO_BLOCK;

    public GlowstickEntity(EntityType<? extends GlowstickEntity> type, Level world) {
        super(type, world);
    }

    public GlowstickEntity(Level level, LivingEntity thrower) {
        super(ModEntities.GLOWSTICK.get(), thrower, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GLOWSTICK_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        DyeColor color = this.getColor();
        compound.m_128344_("GlowstickColor", color == null ? (byte)16 : (byte)color.m_41060_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        int i = compound.m_128451_("GlowstickColor");
        this.setColor(i == 16 ? null : DyeColor.m_41053_((int)i));
    }

    public DyeColor getColor() {
        int i = (Integer)this.f_19804_.m_135370_(DATA_GLOWSTICK_COLOR);
        return i == 16 ? null : DyeColor.m_41053_((int)i);
    }

    public void setColor(DyeColor glowstickColor) {
        if (glowstickColor != null) {
            this.f_19804_.m_135381_(DATA_GLOWSTICK_COLOR, (Object)glowstickColor.m_41060_());
        } else {
            this.f_19804_.m_135381_(DATA_GLOWSTICK_COLOR, (Object)16);
        }
    }

    protected Item m_7881_() {
        return ModItems.GLOWSTICK.get();
    }

    public void m_7822_(byte id) {
        SimpleParticleType particle = ParticleTypes.f_175827_;
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean canPlace(BlockState state) {
        return state.m_60795_() || state.m_60767_().m_76336_();
    }

    public void placeGlowstick(Level level, BlockPos pos, BlockHitResult hitResult) {
        Direction dir = hitResult.m_82434_();
        BlockPos replacePos = pos;
        Block glowstickCheck = GlowstickEntity.getGlowstickBlock(this.getColor());
        if (dir == Direction.NORTH || dir == Direction.WEST || dir == Direction.DOWN) {
            replacePos = pos.m_121945_(dir);
        }
        BlockState replaceState = level.m_8055_(replacePos);
        boolean waterlogged = replaceState.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
        if (!GlowstickEntity.canPlace(replaceState)) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)glowstickCheck)));
        } else if (dir == Direction.NORTH || dir == Direction.WEST || dir == Direction.DOWN) {
            replacePos = pos.m_121945_(dir);
            level.m_46597_(replacePos, (BlockState)((BlockState)glowstickCheck.m_49966_().m_61124_((Property)RodBlock.f_52588_, (Comparable)dir)).m_61124_((Property)GlowstickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        } else {
            level.m_46597_(pos, (BlockState)((BlockState)glowstickCheck.m_49966_().m_61124_((Property)RodBlock.f_52588_, (Comparable)dir)).m_61124_((Property)GlowstickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        }
    }

    public static Block getGlowstickBlock(DyeColor color) {
        return DYE_COLOR_TO_BLOCK.getOrDefault(color, ModBlocks.GLOWSTICK.get());
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
        this.m_6075_();
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_37282_());
            this.f_150164_ = true;
        }
        Vec3 movement = this.m_20184_();
        double velX = movement.f_82479_;
        double velY = movement.f_82480_;
        double velZ = movement.f_82481_;
        boolean noPhysics = this.isNoPhysics();
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (!(blockstate.m_60795_() || noPhysics || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vector3d1 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vector3d1)) continue;
                this.touchedGround = true;
                break;
            }
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.touchedGround && !noPhysics) {
            ++this.groundTime;
        } else {
            this.groundTime = 0;
            this.m_37283_();
            Vec3 pos = this.m_20182_();
            boolean client = this.f_19853_.f_46443_;
            Vec3 newPos = pos.m_82549_(movement);
            BlockHitResult blockHitResult = this.f_19853_.m_45547_(new ClipContext(pos, newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.m_6662_() != HitResult.Type.MISS && !noPhysics) {
                newPos = blockHitResult.m_82450_();
                BlockPos newBlockPos = new BlockPos(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                this.placeGlowstick(this.f_19853_, newBlockPos, blockHitResult);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (client) {
                this.spawnTrailParticles(pos, newPos);
            }
            double posX = newPos.f_82479_;
            double posY = newPos.f_82480_;
            double posZ = newPos.f_82481_;
            if (!this.m_20068_() && !noPhysics) {
                this.m_20334_(velX, velY - (double)this.m_7139_(), velZ);
            }
            float deceleration = this.getDeceleration();
            if (this.m_20069_() && client) {
                for (int j = 0; j < 4; ++j) {
                    double pY = posY + (double)this.m_20206_() / 2.0;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, posX - velX * 0.25, pY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                }
            }
            this.m_20256_(this.m_20184_().m_82490_((double)deceleration));
            this.m_6034_(posX, posY, posZ);
            this.m_20101_();
            if (!this.m_213877_()) {
                EntityHitResult hitEntity = this.findHitEntity(pos, newPos);
                if (hitEntity != null) {
                    blockHitResult = hitEntity;
                }
                HitResult.Type type = blockHitResult.m_6662_();
                boolean portalHit = false;
                if (type == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)blockHitResult).m_82443_();
                    if (entity instanceof Player) {
                        Player p2;
                        Player p1 = (Player)entity;
                        Entity entity2 = this.m_37282_();
                        if (entity2 instanceof Player && !(p2 = (Player)entity2).m_7099_(p1)) {
                            blockHitResult = null;
                        }
                    }
                } else if (type == HitResult.Type.BLOCK) {
                    BlockPos hitPos = blockHitResult.m_82425_();
                    BlockState hitState = this.f_19853_.m_8055_(hitPos);
                    if (hitState.m_60713_(Blocks.f_50142_)) {
                        this.m_20221_(hitPos);
                        portalHit = true;
                    } else if (hitState.m_60713_(Blocks.f_50446_)) {
                        BlockEntity blockEntity = this.f_19853_.m_7702_(hitPos);
                        if (blockEntity instanceof TheEndGatewayBlockEntity) {
                            TheEndGatewayBlockEntity tile = (TheEndGatewayBlockEntity)blockEntity;
                            if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                                TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)hitPos, (BlockState)hitState, (Entity)this, (TheEndGatewayBlockEntity)tile);
                            }
                        }
                        portalHit = true;
                    }
                }
                if (!(portalHit || blockHitResult == null || type == HitResult.Type.MISS || noPhysics || ForgeHelper.onProjectileImpact((Projectile)this, (HitResult)blockHitResult))) {
                    this.m_6532_((HitResult)blockHitResult);
                    this.f_19812_ = true;
                }
            }
        }
        if (this.hasReachedEndOfLife()) {
            this.reachedEndOfLife();
        }
    }

    static {
        DYE_COLOR_TO_BLOCK = new HashMap();
        DYE_COLOR_TO_BLOCK.put(null, ModBlocks.GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.RED, ModBlocks.RED_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.ORANGE, ModBlocks.ORANGE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.YELLOW, ModBlocks.YELLOW_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIME, ModBlocks.LIME_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.GREEN, ModBlocks.GREEN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.CYAN, ModBlocks.CYAN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIGHT_BLUE, ModBlocks.LIGHT_BLUE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BLUE, ModBlocks.BLUE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.PURPLE, ModBlocks.PURPLE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.MAGENTA, ModBlocks.MAGENTA_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.PINK, ModBlocks.PINK_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BROWN, ModBlocks.BROWN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BLACK, ModBlocks.BLACK_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.WHITE, ModBlocks.WHITE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.GRAY, ModBlocks.GRAY_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIGHT_GRAY, ModBlocks.LIGHT_GRAY_GLOWSTICK.get());
        DATA_GLOWSTICK_COLOR = SynchedEntityData.m_135353_(GlowstickEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

